
(function(window){ "use strict";

if (!Uint16Array.prototype.copyWithin){
    Uint16Array.prototype.copyWithin = Array.prototype.copyWithin;
}

var CircularBuffer = function(n, _arrayType) {
    var arrayType = typeof _arrayType !== 'undefined' ?  _arrayType : Uint16Array;

    this._array= new arrayType(n);
    this.length = n;
    this.begin = 0;
    this.end = 0;
};

CircularBuffer.prototype.push= function(arr) {
    if((arr.length + this.end) > this.length)
    {
        this._array.copyWithin(0, this.begin, this.end);
        this.end = this.end-this.begin;
        this.begin = 0;
    }
    if(arr.length > this.length-this.end) return false;
    this._array.set(arr, this.end);
    this.end = this.end + arr.length;
    return true;
};

CircularBuffer.prototype.pull= function(length) {
    if(length > (this.end-this.begin)) return false;
    var arr = this._array.subarray(this.begin, this.begin+length);
    this.begin = this.begin + length;
    return arr;
};
		
var jsaudio = window.jsaudio = function( url, opts ) {
	opts = opts || {};
        
        var _this = this;

        _this.bufferSize = opts.bufferSize || 4096;

        if (window.AudioContext !== undefined){
            _this.audioCtx = new window.AudioContext();

        }else if (window.webkitAudioContext !== undefined){
            _this.audioCtx = new window.webkitAudioContext(); 
        
        }
//        _this.audioCtx = new (window.AudioContext || window.webkitAudioContext)(); // define audio context
        _this.gainNode = _this.audioCtx.createGain();
        _this.oscilator = _this.audioCtx.createOscillator();
        _this.gainNode.gain.value = 1;

        _this.samplerate = _this.audioCtx.sampleRate;
        _this.channels = 1;
        _this.firstMsg = true;

        _this.liveBuffer = new CircularBuffer(_this.bufferSize*5);

        _this.audioSource = _this.audioCtx.createScriptProcessor(_this.bufferSize, 1, 1);
        _this.audioSource.onaudioprocess = function(e) {
            var output = e.outputBuffer.getChannelData(0);
            var buff = _this.liveBuffer.pull(_this.bufferSize);
            _this.updaterms(buff);
            if(!buff) return;
            for (var i = 0; i < _this.bufferSize; i++) {
                output[i] = (buff[i]/65535.0)*2-1;
            }
        };

        _this.oscilator.connect(_this.audioSource);
        _this.audioSource.connect(_this.gainNode);

	if( url instanceof WebSocket ) {
		_this.client = url;
		_this.client.onopen = _this.initSocketClient.bind(_this);
	}
};



// ----------------------------------------------------------------------------
// Streaming over WebSockets

jsaudio.prototype.SOCKET_MAGIC_BYTES = 'jsad';

jsaudio.prototype.initSocketClient = function( client ) {

        this.client.binaryType = 'arraybuffer';
	this.client.onmessage = this.receiveSocketMessage.bind(this);

};

jsaudio.prototype.onInvalidFormat = function( cb ) {

        this.invalidFormatCb = cb;

};

jsaudio.prototype.receiveSocketMessage = function( evt ) {

    if(this.first_msg)
    {

        var data = new Uint8Array(evt.data);

        if( 
	    data[0] == this.SOCKET_MAGIC_BYTES.charCodeAt(0) && 
	    data[1] == this.SOCKET_MAGIC_BYTES.charCodeAt(1) && 
	    data[2] == this.SOCKET_MAGIC_BYTES.charCodeAt(2) && 
	    data[3] == this.SOCKET_MAGIC_BYTES.charCodeAt(3)
	){

            channels = (data[4] * 256 + data[5]);
            samplerate = (data[6] * 256 + data[7]);
            if(this.invalidFormatCb){
                if(channels !== this.channels && samplerate !== this.samplerate)
                    this.invalidFormatCb(channels, samplerate);
            } else
                this.first_msg = false;
        }
        return;
    }

    this.liveBuffer.push(new Uint16Array(evt.data));

};

jsaudio.prototype.updaterms = function( buf ) {

    var sum=0.0;
    var val=0.0;
    for(var i=0 ; i<buf.length; i++) {
        val = (buf[i]/65535.0)*2-1;
        sum += (val*val);
    }

    var rms = Math.sqrt(sum/buf.length);

    if(this.updatermscb) this.updatermscb(rms);
    return rms;

};

jsaudio.prototype.onupdaterms = function( cb ) {

    this.updatermscb = cb;

};

jsaudio.prototype.play = function() {

    this.gainNode.connect(this.audioCtx.destination);
    if(this.oscilator.noteOn) this.oscilator.noteOn(0);

};

jsaudio.prototype.pause = function() {

    this.gainNode.disconnect();

};

jsaudio.prototype.close = function() {
    
    this.audioCtx.close();

};
	
})(window);
