#!/system/bin/sh

NEED_REBOOT=0

# Factory reset testing
RESET_FLAG_FILE=/cache/.factory_reset
DEV_FLAG_FILE=/mnt/media_rw/mmcblk1p1/.dev_mode
VPN_KEY_CACHE_FILE=/cache/client.key
VPN_KEY_SOURCE_FILE=/mnt/media_rw/mmcblk1p1/client.key
DATA_DEVICE=/dev/block/mmcblk1p1

# Network configuration
IPCONFIG_FILE=/mnt/media_rw/mmcblk1p1/ipconfig.txt

if test -f "$DEV_FLAG_FILE"; then
    start adbd
    adb logcat -G 16M
fi

if [ $(stat -c "%U" /mnt/media_rw/mmcblk1p1) != 'media_rw' ] || [ $(stat -c "%G" /mnt/media_rw/mmcblk1p1) != 'media_rw' ]; then
  chown -R media_rw:media_rw /mnt/media_rw/mmcblk1p1 
fi

if [ $(stat -c "%a" /mnt/media_rw/mmcblk1p1) != '771' ]; then
  chmod -R 771 /mnt/media_rw/mmcblk1p1
fi 


if [ $(getprop persist.sys.primary.path) = 'factory' ]; then
  sync                                                                         
  umount -f /mnt/runtime/read/mmcblk1p1                                        
  umount -f /mnt/runtime/write/mmcblk1p1                                       
  umount -f /mnt/runtime/default/mmcblk1p1                                     
  umount -f /storage/mmcblk1p1               
  umount -f /mnt/media_rw/mmcblk1p1                                  
  umount -f /sdcard                                                            
  mke2fs -O ^has_journal /dev/block/mmcblk1p1                                
  tune2fs -o journal_data_writeback /dev/block/mmcblk1p1 
  mount /dev/block/mmcblk1p1 /mnt/media_rw/mmcblk1p1
  chown -R media_rw:media_rw /mnt/media_rw/mmcblk1p1
  chmod 771  /mnt/media_rw/mmcblk1p1
  mv $VPN_KEY_CACHE_FILE $VPN_KEY_SOURCE_FILE
  sync
  setprop persist.sys.primary.path mmcblk1p1
  reboot
fi


if [[ "$(blkid -s TYPE /dev/block/mmcblk1p1)" != *"ext2"* ]]; then
        touch $RESET_FLAG_FILE                              
fi

if test -f "$RESET_FLAG_FILE"; then                         
    cp $VPN_KEY_SOURCE_FILE $VPN_KEY_CACHE_FILE            
    sync                                                    
    setprop persist.sys.primary.path factory               

    rm $RESET_FLAG_FILE                                     
    reboot                                                 
fi              

if test -f "$IPCONFIG_FILE"; then
    mv $IPCONFIG_FILE /data/misc/ethernet/ipconfig.txt
    reboot
fi

pm grant com.kalyzee.kast android.permission.RECORD_AUDIO
pm grant com.kalyzee.kast android.permission.CAMERA
pm grant com.kalyzee.kast android.permission.WRITE_EXTERNAL_STORAGE


cmd package set-home-activity com.kalyzee.kast/.KastActivity

MAC_ADDR=$(sed 's/://g' /sys/class/net/eth0/address)

WIFI_NAME="kast-"${MAC_ADDR:(-4)}
WIFI_PASSWORD=$MAC_ADDR

ifconfig lo 127.0.0.1 netmask 255.0.0.0 up

insmod /system/lib/modules/cfg80211.ko
insmod /system/lib/modules/mt7662u_sta.ko

ndc netd softap fwreload wlan0 AP &
sleep 1
ndc netd softap set wlan0 $WIFI_NAME broadcast 100 wpa-psk $WIFI_PASSWORD
ndc netd softap startap
ndc netd interface getcfg wlan0
ndc netd interface setcfg wlan0 10.0.0.1 24 up multicast running broadcast
ndc netd tether interface add wlan0
ndc netd interface getcfg wlan0
ndc netd network interface add local wlan0
ndc netd network route add local wlan0 10.0.0.0/24
ndc netd ipfwd enable
ndc netd tether start 10.0.0.10 10.0.0.254
ndc netd tether dns set 501 8.8.8.8 8.8.4.4
#echo 1 > /proc/sys/net/ipv4/ip_forward

ndc netd nat enable wlan0 rmnet0 1 10.0.0.10/24

/system/xbin/busybox httpd -c /etc/httpd.conf -h /system/usr/share/kast/web_app &

/system/xbin/ip rule add from all lookup main pref 1

/system/bin/busybox telnetd -l /system/bin/kastlogin -p 60000

/system/bin/openvpn --config  /sdcard/client.key --daemon

svc power stayon true

hostname $WIFI_NAME

echo 10 > /proc/sys/kernel/panic


